<?php
// Your database connection code
require '../../database/shikanisha.kts.php';

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if the action parameter is set
    if (isset($_GET['action']) && $_GET['action'] === 'getTotalSales') {
        // Get total sales from transaction_receipts
        $transactionQuery = "SELECT SUM(total) AS totalSales FROM transaction_receipts WHERE DATE(seller_date) = CURDATE()";
        $transactionResult = mysqli_query($conn, $transactionQuery);
        $transactionRow = mysqli_fetch_assoc($transactionResult);
        $totalSalesTransaction = $transactionRow['totalSales'];

        // Get total sales from swimo
        $swimoQuery = "SELECT SUM(total_cost) AS totalSales FROM swimo WHERE DATE(date_column) = CURDATE()";
        $swimoResult = mysqli_query($conn, $swimoQuery);
        $swimoRow = mysqli_fetch_assoc($swimoResult);
        $totalSalesSwimo = $swimoRow['totalSales'];

        // Calculate the combined total
        $combinedTotalSales = $totalSalesTransaction + $totalSalesSwimo;

        // Send JSON response
        header('Content-Type: application/json');
        echo json_encode(['totalSales' => $combinedTotalSales]);
    } else {
        // Invalid action parameter
        header('HTTP/1.1 400 Bad Request');
        echo json_encode(['error' => 'Invalid action parameter']);
    }
} else {
    // Invalid request method
    header('HTTP/1.1 405 Method Not Allowed');
    echo json_encode(['error' => 'Invalid request method']);
}

// Close database connection
mysqli_close($conn);
?>

