<?php
// Include your database connection code
require 'shikanisha.kts.php';

// Check if roomId is set and not empty
if (isset($_POST['roomId']) && !empty($_POST['roomId'])) {
    // Sanitize and validate the roomId
    $roomId = $_POST['roomId'];

    // Prepare and execute SQL query to delete the room
    $query = "DELETE FROM rooms WHERE room_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $roomId);
    
    if ($stmt->execute()) {
        // Room deleted successfully
        $response = array('success' => true);
    } else {
        // Failed to delete room
        $response = array('success' => false, 'message' => 'Error deleting room from database');
    }

    // Close prepared statement
    $stmt->close();
} else {
    // roomId not provided or invalid
    $response = array('success' => false, 'message' => 'Invalid roomId');
}

// Return JSON response
echo json_encode($response);
?>
