<?php
// your database connection code here
require_once('shikanisha.kts.php');

if (isset($_GET['issue_id'])) {
    $issueId = $_GET['issue_id'];

    // Assuming you have a database table named 'issued_products'
    $sql = "SELECT product_name, quantity, product_id FROM issued_products WHERE issue_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $issueId);
    $stmt->execute();

    $result = $stmt->get_result();

    $data = array();
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    $stmt->close();

    header('Content-Type: application/json');
    echo json_encode($data);
} else {
    // Handle the case when 'issue_id' parameter is not set
    echo json_encode(array('error' => 'Issue ID parameter is missing.'));
}
?>
