<?php
include_once 'shikanisha.kts.php';

// Check for POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Your SQL query remains the same
    $sql = "SELECT tr.seller_name, SUM(s.subtotal) AS total_sales
            FROM sales s
            JOIN transaction_receipts tr ON s.trans_id = tr.trans_id
            WHERE
    `seller_date` >= NOW() - INTERVAL 14 HOUR;
            GROUP BY tr.seller_name
            ORDER BY total_sales DESC;";

    $result = mysqli_query($conn, $sql);

    $data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = [
            'seller_name' => $row['seller_name'],
            'total_sales' => $row['total_sales']
        ];
    }

    // Return the data as JSON
    header('Content-Type: application/json');
    echo json_encode(['data' => $data]);
} else {
    echo json_encode(['error' => 'Invalid request method.']);
}
?>
