<?php
// Include your database connection code
require 'shikanisha.kts.php';

// Check if roomId is provided in the request
if (isset($_GET['roomId'])) {
    // Get the roomId from the request
    $roomId = $_GET['roomId'];

    // Fetch room details from the database
    $query = "SELECT `room_id`, `room_name`, `price`, `description` FROM `rooms` WHERE `room_id` = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $roomId);
    $stmt->execute();
    $result = $stmt->get_result();
    $roomDetails = $result->fetch_assoc();
    $stmt->close();

    // Check if room details were found
    if ($roomDetails) {
        // Return JSON response with room details
        header('Content-Type: application/json');
        echo json_encode($roomDetails);
    } else {
        // Return error response if room details were not found
        http_response_code(404);
        echo json_encode(array("error" => "Room details not found."));
    }
}

// Close the database connection
$conn->close();
?>
