<?php
include_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['trans_id'])) {
    $transId = $conn->real_escape_string($_POST['trans_id']);

    // Fetch room sales data based on the provided transaction ID
    $sql = "SELECT rsid, trans_id, room_name, room_id, nod, room_price, subtotal FROM room_sales WHERE trans_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $transId);
    $stmt->execute();
    $result = $stmt->get_result();

    $roomSalesData = [];
    while ($row = $result->fetch_assoc()) {
        $roomSalesData[] = $row;
    }

    // Return room sales data as JSON response
    echo json_encode($roomSalesData);
} else {
    // Invalid request
    echo json_encode(['error' => 'Invalid request']);
}
?>
