<?php
// database connection script
include_once 'shikanisha.kts.php';
// Check if start_date and end_date are set
if (isset($_POST['start_date']) && isset($_POST['end_date'])) {
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];

    // Your SQL query to fetch data from expenses table
    $sql = "SELECT `expense_id`, `expense_name`, `expense_amount`, `date_incurred` FROM `expenses` WHERE `date_incurred` BETWEEN ? AND ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('ss', $start_date, $end_date);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $data = array();

        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        // Respond with JSON data
        echo json_encode(['data' => $data]);
    } else {
        // Respond with an error
        echo json_encode(['error' => 'Error executing query']);
    }

    $stmt->close();
} else {
    // Respond with an error if start_date and end_date are not set
    echo json_encode(['error' => 'start_date and end_date are required']);
}
?>
