<?php
include_once 'shikanisha.kts.php';

// Check if invoId is set in the request
if (isset($_GET['requestId'])) {
    $invoId = $_GET['requestId'];

    // Your SQL query to fetch invoice details based on invoId
    $sql = "SELECT `irid`, `product_name`, `quantity`
            FROM `request_items`
            WHERE `request_id` = ?";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        // Handle error properly
        echo 'Error in preparing the SQL statement.';
        exit();
    }

    $stmt->bind_param("i", $invoId);
    $stmt->execute();
    $result = $stmt->get_result();

    // Build HTML content for invoice details
    $htmlContent = '<table class="table">
                        <thead>
                            <tr>
                                <th>Product Name</th>
                                <th>Quantity</th>
                            </tr>
                        </thead>
                        <tbody>';

    while ($row = $result->fetch_assoc()) {
        $htmlContent .= '<tr>
                            <td>' . $row['product_name'] . '</td>
                            <td>' . $row['quantity'] . '</td>
                        </tr>';
    }

    $htmlContent .= '</tbody>
                    </table>';

    // Close the statement
    $stmt->close();

    // Output the HTML content
    echo $htmlContent;
} else {
    // If invoId is not set in the request, return an error message
    echo 'Invalid request. InvoId parameter is missing.';
}
?>
