<?php
include_once 'shikanisha.kts.php';

// Get input room ID
$roomId = $_POST['roomId'];

// Your SQL query to fetch all booked and checked-in dates with status information
$sqlAllDates = "SELECT check_in_date, check_out_date, status FROM bookings WHERE room_id = ? AND status IN ('Booked', 'Checked_in')";

// Prepare and bind the SQL statement
$stmt = $conn->prepare($sqlAllDates);
$stmt->bind_param('i', $roomId);

// Execute the statement
$stmt->execute();

// Fetch the result
$result = $stmt->get_result();

// Fetch all booked and checked-in dates
$allDates = [];
while ($row = $result->fetch_assoc()) {

    $allDates[] = [
        'title' => $row['status'],
        'start' => $row['check_in_date'],
        'end' => $row['check_out_date'],
        'isBookedOrCheckedIn' => true, // Add this property based on your condition
    ];
}

// Close the statement
$stmt->close();

// Close the database connection
$conn->close();

// Return the booked and checked-in dates as JSON
echo json_encode($allDates);
?>
