<?php
// Assuming you have a database connection established
require_once('shikanisha.kts.php');

// Start the session
session_start();

if (isset($_POST['searchTerm'])) {
    $searchTerm = mysqli_real_escape_string($conn, $_POST['searchTerm']); // Use mysqli_real_escape_string to prevent SQL injection

    // Assuming your database table is named 'products'
    $query = "SELECT `product_id`, `product_name`, `buying_price` FROM `products` WHERE `product_name` LIKE '%$searchTerm%'";

    // Add additional filters based on user type
    if (isset($_SESSION['type'])) {
        $userType = $_SESSION['type'];

        if ($userType == 'Receptionist') {
            $query .= " AND `category` = 'Consumable'";
        }elseif ($userType == 'Cashier' OR $userType == 'Waiter') {
    $query .= " AND (`category` = 'Product' OR `category` = 'Food-Item')";
}

        // If user type is Manager or Supervisor, no additional filter needed
    }

    // Execute the query and fetch results
    $result = mysqli_query($conn, $query);

    if ($result) {
        echo '<div class="table-responsive">';
        echo '<table class="table">';
        echo '<thead>';
        echo '<tr>';
        echo '<th>Product Name</th>';
        echo '<th>Buying Price</th>';
        echo '<th>Quantity</th>';
        echo '<th>Action</th>';
        echo '</tr>';
        echo '</thead>';
        echo '<tbody>';

        while ($row = mysqli_fetch_assoc($result)) {
            $rowIdentifier = 'row_' . $row['product_id']; // Unique identifier for each row

            echo '<tr id="' . $rowIdentifier . '">';
            echo '<td>' . $row['product_name'] . '</td>';
            echo '<td><input type="text" class="form-control input-rounded buying-price" placeholder="Buying Price" value="' . $row['buying_price'] . '" id="buying-price-' . $rowIdentifier . '"/></td>';
            echo '<td><input type="text" class="form-control input-rounded quantity" placeholder="Quantity" id="quantity-' . $rowIdentifier . '"/></td>';
            echo '<td><button class="btn btn-secondary" onclick="addToCart(\'' . $rowIdentifier . '\', ' . $row['product_id'] . ', \'' . $row['product_name'] . '\')">Add to Cart</button></td>';
            echo '</tr>';
        }

        echo '</tbody>';
        echo '</table>';
        echo '</div>';
    } else {
        echo 'Error: ' . mysqli_error($conn);
    }
}
?>


<script>
function addToCart(rowIdentifier, productId, productName) {
    var buyingPrice = parseFloat($('#buying-price-' + rowIdentifier).val());
    var quantity = parseInt($('#quantity-' + rowIdentifier).val());

    if (!isNaN(buyingPrice) && !isNaN(quantity) && quantity > 0) {
        // AJAX request to the server-side script (update_cart.php)
        $.ajax({
            url: './database/update_cart.kts.php',
            method: 'POST',
            data: {
                productId: productId,
                productName: productName,
                buyingPrice: buyingPrice,
                quantity: quantity
            },
            success: function (response) {
                console.log(response);
                // You can update the UI here if needed
                // Clear the input values
                $('#buying-price-' + rowIdentifier).val('');
                $('#quantity-' + rowIdentifier).val('');
                 $('#searchInput').val('');
                 $('#' + rowIdentifier).empty().hide(); // Remove the row from the table
            }
        });
    } else {
        alert('Please enter valid values for Buying Price and Quantity.');
    }
}
</script>
