<?php
// Replace these values with your database connection information
require_once 'shikanisha.kts.php';

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the search query from the POST request
if (isset($_POST["query"])) {
    $query = $_POST["query"];

    $stmt = $conn->prepare("SELECT product_name,category, product_id, shop_quantity, selling_price FROM products WHERE (product_name LIKE ?) AND shop_quantity > 0 AND (category = 'Food' OR category = 'Product')");
    $searchParam = "%{$query}%";
    $stmt->bind_param("s", $searchParam);
    $stmt->execute();
    $result = $stmt->get_result();

    // Display search results in a table
    echo '<div class="table-responsive">';
    echo '<table class="table table-striped">';
    echo "<thead>";
    echo "<tr>";
    echo "<th>Product Name</th>";
    echo "<th>Price</th>";
    echo "<th>Quantity</th>";
    echo "<th>Action</th>";
    echo "</tr>";
    echo "</thead>";
    echo "<tbody>";

   while ($row = $result->fetch_assoc()) {
    echo "<tr>";
    echo "<td>{$row['product_name']}</td>";

    // Check if the price is numeric before displaying it
    if (is_numeric($row['selling_price'])) {
        echo "<td>";
        echo "<select class='price-dropdown'>";
        echo "<option value='{$row['selling_price']}'>{$row['selling_price']}</option>";
        echo "<option value='custom'>Custom Input</option>";
        echo "</select>";
        echo '<input type="number" name="custom_price" class="customPrice" placeholder="Custom Price" step="0" style="display: none;" />';
        echo "</td>";
    } else {
        echo "<td>Invalid Price</td>"; // Display an error message if price is not numeric
    }

    echo "<td><input type='number' class='quantity-input' min='1' value='1'  required></td>";

    echo "<td><button class='btn btn-sm btn-rounded btn-outline-success add-to-cart' data-itemname='{$row['product_name']}' data-productid='{$row['product_id']}'>Add to Cart</button></td>";
    echo "</tr>";
}
    echo "</tbody>";
    echo "</table>";
    echo "</div>";

    // Close the database connection
    $stmt->close();
    $conn->close();
}
?>


<script>
$(document).ready(function () {
    // Function to handle select change event
    function handleSelectChange() {
        // Get the selected value
        var selectedValue = $(".price-dropdown").val();

        // Find the associated custom price input field
        var customPriceInput = $(".customPrice");

        // Check if it's "custom"
        if (selectedValue === "custom") {
            // Show the custom input field
            customPriceInput.show();
        } else {
            // Hide the custom input field
            customPriceInput.hide();
        }
    }

    // Attach change event handler to the select element with class "price-dropdown"
    $(".price-dropdown").change(function() {
        handleSelectChange();
    });

    // Initial call to handleSelectChange for any pre-selected "Custom" options
    handleSelectChange();
});
</script>