<?php
// Include database connection or any necessary files
require_once('shikanisha.kts.php');

// Default values for pagination
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$limit = 6; // Number of items per page

// Calculate offset for pagination
$offset = ($page - 1) * $limit;

// Define specific categories
$categories = array('Meat', 'Chicken', 'Vegetables', 'Fish', 'Drinks');

// Initialize an array to store fetched items
$allItems = array();

// Loop through each category and fetch items
foreach ($categories as $category) {
    // Fetch items from the database based on the category and pagination
    $query = "SELECT * FROM products WHERE food_group = '$category' LIMIT $limit OFFSET $offset";
    $result = mysqli_query($conn, $query);

    // Initialize an array to store fetched items for this category
    $categoryItems = array();

    // Check if there are any items fetched for this category
    if (mysqli_num_rows($result) > 0) {
        // Fetch items data from the result set
        while ($row = mysqli_fetch_assoc($result)) {
            $categoryItems[] = $row;
        }
    }

    // Add category items to the overall items array
    $allItems[$category] = $categoryItems;
}

// Output the items in JSON format
echo json_encode($allItems);

// Close database connection
mysqli_close($conn);
?>
