function generateReport() {
    // Get start and end dates
    var startDate = $('#start_date').val();
    var endDate = $('#end_date').val();

    // AJAX request to fetch data
    $.ajax({
        url: './database/get_swimming_report.kts.php',
        type: 'POST',
        data: {
            start_date: startDate,
            end_date: endDate
        },
        dataType: 'json',
        success: function(response) {
            // Update the table with fetched data
            updateTable(response.data);
        },
        error: function(xhr, status, error) {
            // Handle AJAX errors
            console.error('AJAX Error: ' + error);
        }
    });
}

function updateTable(data) {
    // Clear existing table data
    $('#expenseTable tbody').empty();

    // Populate the table with new data
    for (var i = 0; i < data.length; i++) {
        var row = '<tr>' +
                      '<td>' + data[i].swimo_id + '</td>' +
                      '<td>' + data[i].age_group + '</td>' +
                      '<td>' + data[i].cost + '</td>' +
                      '<td>' + data[i].no_persons + '</td>' +
                      '<td>' + data[i].date_column + '</td>' +
                      '<td>' + data[i].total_cost + '</td>' +
                  '</tr>';
        $('#expenseTable tbody').append(row);
    }

  
  
    // Calculate and display total expense
    var totalExpense = data.reduce(function (sum, item) {
        return sum + parseFloat(item.total_cost);
    }, 0);

    $('#totalExpense').text(totalExpense.toFixed(2));
}
