<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<!-- Include Bootstrap CSS -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">

<!-- Include FullCalendar CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/5.9.0/main.min.css" />

<!-- Include FullCalendar JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/5.9.0/main.min.js"></script>

<!-- Your other script tags -->
<script src="./quixlab/plugins/sweetalert2/dist/sweetalert2.min.js"></script>
<script src="./quixlab/plugins/chart.js/Chart.bundle.min.js"></script>

<!-- ... (other scripts) -->

<!-- Your custom script -->


<script>
  document.addEventListener('DOMContentLoaded', function () {
 function renderCalendar(allDates, roomId) {
        // Create a modal or use an existing one
        $('#calendarModal').modal('show');

        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            events: JSON.parse(allDates),
            eventRender: function (info) {
                // Get the HTML of the default event rendering
                var defaultHtml = info.event.toPlainObject().content;

                // Append a circle to the event HTML
                var circleHtml = '<div class="circle"></div>';
                info.el.innerHTML = defaultHtml + circleHtml;
            },
        });

        calendar.render();
    }

});</script>