<?php
// Your database connection code
require '../../database/shikanisha.kts.php';

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if the action parameter is set
    if (isset($_GET['action']) && $_GET['action'] === 'getYearlyTotals') {
        // Get the current year
        $currentYear = date('Y');

        // Calculate the start and end dates for the current year
        $currentYearStart = (new DateTime("$currentYear-01-01"))->format('Y-m-d');
        $currentYearEnd = (new DateTime("$currentYear-12-31"))->format('Y-m-d');

        // Fetch total sales for the current year
        $totalSalesQuery = "SELECT SUM(total) AS totalSales FROM transaction_receipts WHERE seller_date BETWEEN ? AND ?";
        $totalSalesStmt = $conn->prepare($totalSalesQuery);
        $totalSalesStmt->bind_param("ss", $currentYearStart, $currentYearEnd);
        $totalSalesStmt->execute();
        $totalSalesResult = $totalSalesStmt->get_result();
        $totalSales = $totalSalesResult->fetch_assoc()['totalSales'];

        // Fetch total sales from swimo for the current year
        $totalSwimoQuery = "SELECT SUM(total_cost) AS totalSales FROM swimo WHERE date_column BETWEEN ? AND ?";
        $totalSwimoStmt = $conn->prepare($totalSwimoQuery);
        $totalSwimoStmt->bind_param("ss", $currentYearStart, $currentYearEnd);
        $totalSwimoStmt->execute();
        $totalSwimoResult = $totalSwimoStmt->get_result();
        $totalSwimoSales = $totalSwimoResult->fetch_assoc()['totalSales'];

        // Fetch total expenses for the current year
        $totalExpensesQuery = "SELECT SUM(expense_amount) AS totalExpenses FROM expenses WHERE date_incurred BETWEEN ? AND ?";
        $totalExpensesStmt = $conn->prepare($totalExpensesQuery);
        $totalExpensesStmt->bind_param("ss", $currentYearStart, $currentYearEnd);
        $totalExpensesStmt->execute();
        $totalExpensesResult = $totalExpensesStmt->get_result();
        $totalExpenses = $totalExpensesResult->fetch_assoc()['totalExpenses'];

        // Fetch total payslip expenses for the current year
        $totalPayslipExpensesQuery = "SELECT SUM(netPay) AS totalPayslip FROM table_payslip WHERE date BETWEEN ? AND ?";
        $totalPayslipExpensesStmt = $conn->prepare($totalPayslipExpensesQuery);
        $totalPayslipExpensesStmt->bind_param("ss", $currentYearStart, $currentYearEnd);
        $totalPayslipExpensesStmt->execute();
        $totalPayslipExpensesResult = $totalPayslipExpensesStmt->get_result();
        $totalPayslipExpenses = $totalPayslipExpensesResult->fetch_assoc()['totalPayslip'];

        // Fetch total purchases for the current year
        $totalPurchasesQuery = "SELECT SUM(total) AS totalPurchases FROM invoice WHERE date BETWEEN ? AND ?";
        $totalPurchasesStmt = $conn->prepare($totalPurchasesQuery);
        $totalPurchasesStmt->bind_param("ss", $currentYearStart, $currentYearEnd);
        $totalPurchasesStmt->execute();
        $totalPurchasesResult = $totalPurchasesStmt->get_result();
        $totalPurchases = $totalPurchasesResult->fetch_assoc()['totalPurchases'];

        // Calculate the total expenses
        $totalExpenses = $totalExpenses + $totalPayslipExpenses + $totalPurchases;

        // Prepare data for JSON response
        $response = [
            'totalSales' => $totalSales + $totalSwimoSales,
            'totalExpenses' => $totalExpenses,
        ];

        // Send the response as JSON
        header('Content-Type: application/json');
        echo json_encode($response);
    } else {
        // Invalid action parameter
        $response = [
            'success' => false,
            'error' => 'Invalid action parameter',
        ];

        // Send the response as JSON
        header('Content-Type: application/json');
        echo json_encode($response);
    }
} else {
    // Invalid request method
    $response = [
        'success' => false,
        'error' => 'Invalid request method',
    ];

    // Send the response as JSON
    header('Content-Type: application/json');
    echo json_encode($response);
}
?>
