<?php
// Your database connection code
require '../../database/shikanisha.kts.php';

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if the action parameter is set
    if (isset($_GET['action']) && $_GET['action'] === 'getVendors') {
        // Fetch vendor details from the database
        $sql = "SELECT vendors.vendor_name, vendors.company, vendor_debts.amount_owed, vendors.vendor_phone 
                FROM vendors
                JOIN vendor_debts ON vendors.vendor_id = vendor_debts.vendor_id";
        $result = mysqli_query($conn, $sql);

        // Check if there are any results
        if ($result) {
            $vendor_details = mysqli_fetch_all($result, MYSQLI_ASSOC);
            echo json_encode($vendor_details);
        } else {
            // If there are no results, return an error message
            echo json_encode(['error' => 'No vendor details found']);
        }
    } else {
        // Invalid action parameter
        echo json_encode(['error' => 'Invalid action parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>
