<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Bar Chart</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <canvas id="barChart"></canvas>
    <?php
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "rahisient";

    // Create connection
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Retrieve data for each day of the week
    $sql = "SELECT DAYNAME(date) AS day, 
            SUM(total) AS total_sales, 
            SUM(amount_received) AS total_received, 
            SUM(total - amount_received) AS total_debt, 
            SUM(CASE WHEN payment_method = 'Cash' THEN amount_received ELSE 0 END) AS cash_total, 
            SUM(CASE WHEN payment_method = 'Mpesa' THEN amount_received ELSE 0 END) AS mpesa_total, 
            SUM(CASE WHEN payment_method = 'Hfc' THEN amount_received ELSE 0 END) AS hfc_total, 
            SUM(CASE WHEN payment_method = 'Equity' THEN amount_received ELSE 0 END) AS equity_total 
            FROM transactions_receipts 
            WHERE date >= DATE(NOW()) - INTERVAL 1 WEEK
            GROUP BY DAYNAME(date)";

    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // Prepare data for the chart
        $labels = array();
        $cash_data = array();
        $mpesa_data = array();
        $hfc_data = array();
        $equity_data = array();
        while($row = $result->fetch_assoc()) {
            array_push($labels, $row["day"]);
            array_push($cash_data, $row["cash_total"]);
            array_push($mpesa_data, $row["mpesa_total"]);
            array_push($hfc_data, $row["hfc_total"]);
            array_push($equity_data, $row["equity_total"]);
        }
    } else {
        echo "0 results";
    }
    $conn->close();
    ?>

    <script>
    // Bar chart
    var ctx = document.getElementById("barChart");
    ctx.height = 150;
    var myChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($labels); ?>,
            datasets: [
                {
                    label: "Cash",
                    data: <?php echo json_encode($cash_data); ?>,
                    borderColor: "rgba(117, 113, 249, 0.9)",
                    borderWidth: "0",
                    backgroundColor:"rgba(111, 217, 111, 0.9)"
                },
                {
                    label: "Mpesa",
                    data: <?php echo json_encode($mpesa_data); ?>,
                    borderColor: "rgba(117, 113, 249, 0.9)",
                    borderWidth: "0",
                    backgroundColor: "rgba(86, 249, 255, 0.7)"
                },
                {
                    label: "HFC",
                    data: <?php echo json_encode($hfc_data); ?>,
                    borderColor: "rgba(117, 113, 249, 0.9)",
                    borderWidth: "0",
                    backgroundColor: "rgba
            },
            {
                label: "Equity",
                data: <?php echo json_encode($equity_data); ?>,
                borderColor: "rgba(117, 113, 249, 0.9)",
                borderWidth: "0",
                backgroundColor: "rgba(255, 158, 0, 0.9)"
            }
        ]
    },
    options: {
        scales: {
            yAxes: [{
                ticks: {
                    beginAtZero:true
                }
            }]
        }
    }
});
</script>
