<?php
include_once 'shikanisha.kts.php';

// Get input dates
$roomId = $_POST['roomId'];
$checkInDate = $_POST['checkInDate'];
$checkOutDate = $_POST['checkOutDate'];

// Your SQL query to check availability
$sqlAvailability = "SELECT * FROM bookings WHERE room_id = ? AND NOT (check_out_date <= ? OR check_in_date >= ?)";

// Prepare and bind the SQL statement
$stmt = $conn->prepare($sqlAvailability);
$stmt->bind_param('iss', $roomId, $checkInDate, $checkOutDate);

// Execute the statement
$stmt->execute();

// Store the result
$stmt->store_result();

// Get the number of rows returned
$numRows = $stmt->num_rows;

// Close the statement
$stmt->close();

// Check availability based on the number of rows returned
if ($numRows > 0) {
    echo 'Not Available';
} else {
    echo 'Available';
}

// Close the database connection
$conn->close();
?>
