<?php
// Database Connection 
require_once('shikanisha.kts.php');

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if the form was submitted using POST method
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get branch data from POST request
    $branchName = $_POST['branchName'];
    $branchLocation = $_POST['branchLocation'];
    $branchContact = $_POST['branchContact'];

    // Use prepared statement to prevent SQL injection
    $stmt = $conn->prepare("INSERT INTO branch (branch_name, location, contact) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $branchName, $branchLocation, $branchContact);

    // Execute the prepared statement
    if ($stmt->execute()) {
        $response = array('success' => true);
    } else {
        $response = array('success' => false);
    }

    // Close the prepared statement
    $stmt->close();

    // Send JSON response
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    // If the form was not submitted using POST, return an error response
    $response = array('success' => false, 'error' => 'Invalid request method');
    header('Content-Type: application/json');
    echo json_encode($response);
}

// Close the connection
$conn->close();
?>
