<?php
session_start();
// check if the user is authorized to delete the booking
if (isset($_SESSION['type']) && $_SESSION['type'] == 'Manager') {
    // check if the booking id is provided in the URL
    if (isset($_GET['id'])) {
        $booking_id = $_GET['id'];
        // connect to the database
        require_once('shikanisha.kts.php');
        if ($conn->connect_error) {
            die('Connection failed: ' . $conn->connect_error);
        }
        // prepare the delete statement
        $stmt = $conn->prepare("DELETE FROM bookings WHERE booking_id = ?");
        if (!$stmt) {
            die('Error preparing statement: ' . $conn->error);
        }
        $stmt->bind_param('i', $booking_id);
        // execute the statement
        if ($stmt->execute()) {
            // redirect to the bookings page
            header('Location: ../accomodation.php');
            exit();
        } else {
            echo "Error deleting booking: " . $stmt->error;
        }
        // close the statement
        $stmt->close();
        // close the connection
        $conn->close();
    } else {
        echo "Booking id not provided";
    }
} else {
    echo "Unauthorized access";
}
?>
