<?php
// Assuming you have a database connection script (e.g., shikanisha.kts.php)
require('shikanisha.kts.php');

if (isset($_POST['session_id'])) {
    $sessionId = $_POST['session_id'];

    // Use a prepared statement to prevent SQL injection
    $stmt = $conn->prepare("SELECT cost FROM swimming WHERE swimid = ?");
    
    // Check if the prepare statement was successful
    if ($stmt) {
        $stmt->bind_param("i", $sessionId); // Assuming swimid is an integer

        // Execute the prepared statement
        $stmt->execute();

        // Get the result
        $result = $stmt->get_result();

        // Check if there are rows
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $response = array("success" => true, "cost" => $row['cost']);
        } else {
            $response = array("success" => false);
        }

        // Close the prepared statement
        $stmt->close();
    } else {
        // Handle prepare statement error
        $response = array("success" => false, "message" => "Prepare statement error: " . $conn->error);
    }

    // Close the database connection
    $conn->close();

    // Send JSON response back to the JavaScript
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    // Handle case where session_id is not provided
    $response = array("success" => false);
    header('Content-Type: application/json');
    echo json_encode($response);
}
?>
