<?php
include_once 'shikanisha.kts.php';

// Check if invoId is set in the request
if (isset($_GET['invoId'])) {
    $invoId = $_GET['invoId'];

    // Your SQL query to fetch invoice details based on invoId
    $sql = "SELECT `purchase_order_id`, `productname`, `price`, `quantity`, `subtotal`, `purchase_date`
            FROM `purchase_orders`
            WHERE `invo_id` = ?";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        // Handle error properly
        echo 'Error in preparing the SQL statement.';
        exit();
    }

    $stmt->bind_param("i", $invoId);
    $stmt->execute();
    $result = $stmt->get_result();

    // Build HTML content for invoice details
    $htmlContent = '<table class="table">
                        <thead>
                            <tr>
                                <th>Product Name</th>
                                <th>Price</th>
                                <th>Quantity</th>
                                <th>Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>';

    while ($row = $result->fetch_assoc()) {
        $htmlContent .= '<tr>
                            <td>' . $row['productname'] . '</td>
                            <td>' . $row['price'] . '</td>
                            <td>' . $row['quantity'] . '</td>
                            <td>' . $row['subtotal'] . '</td>
                        </tr>';
    }

    $htmlContent .= '</tbody>
                    </table>';

    // Close the statement
    $stmt->close();

    // Output the HTML content
    echo $htmlContent;
} else {
    // If invoId is not set in the request, return an error message
    echo 'Invalid request. InvoId parameter is missing.';
}
?>
