<?php
include_once 'shikanisha.kts.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['sale_id'])) {
    $saleId = $conn->real_escape_string($_POST['sale_id']);

    $query = "SELECT sale_id, trans_id, product_id, product_name, quantity, selling_price, (quantity * selling_price) AS subtotal FROM sales WHERE sale_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $saleId);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($sale = $result->fetch_assoc()) {
        // Return the sale item data
        echo json_encode($sale);
    } else {
        // Return an error if the sale item does not exist
        echo json_encode(['error' => 'Sale item not found.']);
    }
    $stmt->close();
} else {
    // Return an error if the request is not valid
    echo json_encode(['error' => 'Invalid request.']);
}
?>
