<?php
// Include your database connection file
require_once 'shikanisha.kts.php';

// Check if form data is received
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $transId = $_POST['transId'];
    $nod = $_POST['nod'];
    $roomPrice = $_POST['roomPrice'];
    $subtotal = $_POST['subtotal'];

    // Update transaction_receipts table
    $updateReceiptsQuery = "UPDATE transaction_receipts SET total = ? WHERE trans_id = ?";
    $stmt = mysqli_prepare($conn, $updateReceiptsQuery);
    mysqli_stmt_bind_param($stmt, "di", $subtotal, $transId);
    mysqli_stmt_execute($stmt);

    // Update room_sales table
    $updateRoomSalesQuery = "UPDATE room_sales SET nod = ?, room_price = ?, subtotal = ? WHERE trans_id = ?";
    $stmt = mysqli_prepare($conn, $updateRoomSalesQuery);
    mysqli_stmt_bind_param($stmt, "idis", $nod, $roomPrice, $subtotal, $transId);
    mysqli_stmt_execute($stmt);

    // Respond with success message
    $response = ['success' => true, 'message' => 'Data updated successfully'];
    echo json_encode($response);
} else {
    // Respond with error message if no form data received
    $response = ['success' => false, 'message' => 'No form data received'];
    echo json_encode($response);
}
?>
