<?php
// Include your database connection code
require 'shikanisha.kts.php';

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve the room ID and updated details from the POST data
    $roomId = $_POST['roomId'];
    $description = $_POST['description'];
    $price = $_POST['price'];

    // Prepare and execute the SQL update statement
    $query = "UPDATE rooms SET description = ?, price = ? WHERE room_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssi", $description, $price, $roomId);
    $result = $stmt->execute();

    // Check if the update was successful
    if ($result) {
        // Update successful, send success response
        echo json_encode(array('success' => true));
    } else {
        // Update failed, send error response
        echo json_encode(array('success' => false, 'message' => 'Failed to update room details'));
    }

    // Close the prepared statement and database connection
    $stmt->close();
    $conn->close();
} else {
    // If the request method is not POST, send an error response
    echo json_encode(array('success' => false, 'message' => 'Invalid request method'));
}
?>
