<?php
include_once 'shikanisha.kts.php';

// Get the data from the AJAX request
$product_name = $_POST['product-name-input'];
$buying_price = $_POST['buying-price-input'];
$selling_price = $_POST['selling-price-input'];
$product_id = $_POST['product-id-input'];

// Prepare and execute the UPDATE statement
$update_sql = "UPDATE products SET product_name=?, buying_price=?, selling_price=? WHERE product_id=?";
$stmt = $conn->prepare($update_sql);

if (!$stmt) {
    // Handle prepare failure
    echo json_encode(['error' => 'Prepare failed: ' . $conn->error]);
    exit();
}

// Bind parameters and execute the statement
$stmt->bind_param("sddi", $product_name, $buying_price, $selling_price, $product_id);

if ($stmt->execute()) {
    // Successful update
    echo json_encode(['success' => 'Product updated successfully']);
} else {
    // Handle execute failure
    echo json_encode(['error' => 'Update failed: ' . $stmt->error]);
}

// Close the statement and the database connection
$stmt->close();
$conn->close();
?>
